package centrocommerciale;

import centrocommerciale.utils.IFormatter;

/**
 * Contiene la procedura di calcolo dei guadagni
 * 
 * @author koelio
 * 
 */
public class CommercialCentre {

	ICommercialFactory factory;
	IFormatter format;
	private int TOTAL_LOCALS = 85;
	double totalEarnings;

	public CommercialCentre(ICommercialFactory factory, IFormatter format) {
		this.factory = factory;
		this.format = format;
	}

	public void eseguiProc() {
		int loc = 0;

		for (int i = 0; i < format.getSize(); i++) {

			format.setIndex(i);
			if (format.getType().equalsIgnoreCase("comm")) {
				Commercial business = factory.generateBusiness(format.getId(),
						format.getType(), format.getLocalNumber(),
						format.getMqTot(), format.getOwnFixedCosts(),
						format.getIncome());

				this.totalEarnings += business.getEarnings();
			} else if (format.getType().equalsIgnoreCase("serv")) {
				Commercial service = factory.generateService(format.getId(),
						format.getType(), format.getLocalNumber(),
						format.getMqTot(), format.getOwnFixedCosts(),
						format.getIncome());

				this.totalEarnings += service.getEarnings();
			}
			// System.out.println("Non ci sono attività commerciali\n");
			loc += format.getLocalNumber();
		}

		loc = TOTAL_LOCALS - loc;
		System.out.println("\nCi sono " + loc + " locali vuoti");

	}

	public double getGuadagni() {

		return totalEarnings;
	}

}
